using System;
using Server;
using Server.Items;
using Server.Mobiles;

namespace Server.Items
{
	[FlipableAttribute( 0x13B9, 0x13Ba )]
	public class Mec : BaseSword
	{
		public override int ArtifactRarity{ get{ return 100; } }
		
		public override WeaponAbility PrimaryAbility{ get{ return WeaponAbility.CrushingBlow; } }
		public override WeaponAbility SecondaryAbility{ get{ return WeaponAbility.ParalyzingBlow; } }

		public override int AosStrengthReq{ get{ return 40; } }
		public override int AosMinDamage{ get{ return 18; } }
		public override int AosMaxDamage{ get{ return 25; } }
		public override int AosSpeed{ get{ return 35; } }

		public override int OldStrengthReq{ get{ return 40; } }
		public override int OldMinDamage{ get{ return 6; } }
		public override int OldMaxDamage{ get{ return 34; } }
		public override int OldSpeed{ get{ return 30; } }

		public override int DefHitSound{ get{ return 0x237; } }
		public override int DefMissSound{ get{ return 0x23A; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public Mec() : base( 0x13B9 )
		{
			Name = "Mec";
			Weight = 6.0;
			Hue = 1153;
			LootType = LootType.Blessed;
			Attributes.WeaponDamage = 40;
			Attributes.WeaponSpeed = 25;
			Attributes.AttackChance = 35;
			Attributes.DefendChance = 35;
			Attributes.BonusStr = 25;
			Attributes.BonusStam = 25;
			Attributes.Luck = 200;
			Attributes.ReflectPhysical = 20;
			Attributes.RegenHits = 4;
			Attributes.RegenStam = 4;
			WeaponAttributes.HitLeechHits = 30;
			WeaponAttributes.HitFireball = 30;
			WeaponAttributes.HitLightning = 30;
			WeaponAttributes.SelfRepair = 5;
			WeaponAttributes.BattleLust = 1;
			
			SkillBonuses.SetValues( 0, SkillName.Swords, 20.0 );
			SkillBonuses.SetValues( 1, SkillName.Tactics, 20.0 );
		}
		
		public override void GetDamageTypes(Mobile wielder, out int phys, out int fire, out int cold, out int pois, out int nrgy)
		{
			fire = cold = phys = pois = nrgy = 20;
		}
		
		public override void OnHit(Mobile attacker, Mobile defender, double damageBonus)
		{
			if ( !Consecrated )
				Consecrated = true;
			
			if ( attacker.Player && !defender.Player && 0.07 > Utility.RandomDouble() )
				Summon( attacker, defender );
			
			base.OnHit( attacker, defender, damageBonus );
		}
		
		private void Summon( Mobile attacker, Mobile defender )
		{
			if ( attacker == null || defender == null )
				return;
			
			Map map = defender.Map;

			if ( map == null )
				return;

			SumBladeSpirits summon = new SumBladeSpirits();

			bool validLocation = false;
			Point3D loc = defender.Location;

			for ( int j = 0; !validLocation && j < 10; ++j )
			{
				int x = defender.X + Utility.Random( 2 ) + 1;
				int y = defender.Y + Utility.Random( 2 ) + 1;
				int z = map.GetAverageZ( x, y );

				if ( validLocation = ( map.CanFit( x, y, defender.Z, 16, false, false ) && attacker.InLOS( new Point3D(x, y, defender.Z) ) ) )
					loc = new Point3D( x, y, defender.Z );
				else if ( validLocation = ( map.CanFit( x, y, z, 16, false, false ) && attacker.InLOS( new Point3D(x, y, z) ) ) )
					loc = new Point3D( x, y, z );
			}
			
			summon.MoveToWorld( loc, map );
			Effects.PlaySound(loc, map, 0x23A);
			summon.Combatant = defender;
			summon.ControlSlots = 0;
			summon.Summoned = true;
			summon.SummonMaster = attacker;
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#33FF66>Always Consecrated\nSummon Blade Spirits<basefont color=White>" );
		}

		public Mec( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
			
			if ( version == 0 )
			   WeaponAttributes.BattleLust = 1;
		}
	}
}
